"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.encryptMaybe = encryptMaybe;
const node_crypto_1 = __importDefault(require("node:crypto"));
const config_js_1 = require("./config.js");
const KEY = config_js_1.CFG.enc.enabled && config_js_1.CFG.enc.keyB64 ? Buffer.from(config_js_1.CFG.enc.keyB64, "base64") : null;
function encryptMaybe(plaintext) {
    if (!config_js_1.CFG.enc.enabled || !KEY)
        return {};
    const iv = node_crypto_1.default.randomBytes(12);
    const cipher = node_crypto_1.default.createCipheriv("aes-256-gcm", KEY, iv);
    const enc = Buffer.concat([cipher.update(plaintext, "utf8"), cipher.final()]);
    const tag = cipher.getAuthTag();
    return { ciphertext: enc.toString("base64"), iv: iv.toString("base64"), tag: tag.toString("base64") };
}
