import {MongoClient, Db} from "mongodb";
import { CFG } from "./config";

let _db: Db | null = null;

export async function getKbDb(){

    if(_db) return _db;

    const uri = process.env.MONGO_URI || "mongodb://localhost:27017";
    const dbName = process.env.MONGO_DB_NAME || "voice_therapist";

    const client = new MongoClient(uri);
    await client.connect();
    _db = client.db(dbName);
    return _db;
}