"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const fastify_1 = __importDefault(require("fastify"));
const cors_1 = __importDefault(require("@fastify/cors"));
const config_js_1 = require("./config.js");
const vapi_1 = require("./routes/vapi");
const shared_1 = require("@starter/shared");
async function main() {
    const app = (0, fastify_1.default)({ logger: shared_1.logger });
    await app.register(cors_1.default, { origin: true });
    await app.register(vapi_1.registerVapiRoutes);
    app.get("/healthz", async () => ({ ok: true }));
    app.get("/readyz", async () => ({ ok: true }));
    app.listen({ port: config_js_1.CFG.port, host: "0.0.0.0" }).then(() => {
        shared_1.logger.info(`Orchestrator listening on :${config_js_1.CFG.port}`);
    }).catch((err) => {
        app.log.error(err);
        process.exit(1);
    });
}
main();
