"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getDb = getDb;
exports.closeDb = closeDb;
const mongodb_1 = require("mongodb");
const config_js_1 = require("./config.js");
const shared_1 = require("@starter/shared");
let client = null;
let db = null;
async function getDb() {
    if (db)
        return db;
    shared_1.logger.info({ uri: config_js_1.CFG.mongoUri }, "Connecting to MongoDB");
    client = new mongodb_1.MongoClient(config_js_1.CFG.mongoUri);
    await client.connect();
    db = client.db();
    // Create indexes for better performance
    await createIndexes(db);
    shared_1.logger.info({ dbName: db.databaseName }, "Connected to MongoDB");
    return db;
}
async function createIndexes(database) {
    try {
        // Calls collection indexes
        await database.collection("calls").createIndex({ callId: 1 }, { unique: true });
        await database.collection("calls").createIndex({ startedAt: -1 });
        await database.collection("calls").createIndex({ callStatus: 1 });
        await database.collection("calls").createIndex({ fromNumber: 1 });
        await database.collection("calls").createIndex({ crisis_flag: 1 });
        await database.collection("calls").createIndex({ escalated: 1 });
        // Utterances collection indexes
        await database.collection("utterances").createIndex({ callId: 1, ts: 1 });
        await database.collection("utterances").createIndex({ expiresAt: 1 }, { expireAfterSeconds: 0 });
        shared_1.logger.info("Database indexes created successfully");
    }
    catch (error) {
        shared_1.logger.error({ error }, "Failed to create database indexes");
    }
}
async function closeDb() {
    if (client) {
        await client.close();
        client = null;
        db = null;
        shared_1.logger.info("MongoDB connection closed");
    }
}
